<?php
/**
 * Plugin Name: Badger
 * Plugin URI: https://badgerwp.com
 * Description: Don't just block AI bots. Trap them. AI agent detection and honeypot plugin for WordPress.
 * Version: 0.1.0
 * Author: Badger
 * Author URI: https://badgerwp.com
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: badger
 * Requires at least: 6.0
 * Requires PHP: 8.0
 */

declare(strict_types=1);

if (!defined('ABSPATH')) {
    exit;
}

define('BADGER_VERSION', '0.1.0');
define('BADGER_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('BADGER_PLUGIN_URL', plugin_dir_url(__FILE__));

require_once BADGER_PLUGIN_DIR . 'includes/class-badger-activator.php';
require_once BADGER_PLUGIN_DIR . 'includes/class-badger-detector.php';
require_once BADGER_PLUGIN_DIR . 'includes/class-badger-honeypot.php';
require_once BADGER_PLUGIN_DIR . 'includes/class-badger-blocker.php';
require_once BADGER_PLUGIN_DIR . 'includes/class-badger-robots.php';
require_once BADGER_PLUGIN_DIR . 'includes/class-badger-hardening.php';
require_once BADGER_PLUGIN_DIR . 'includes/class-badger-rate-limiter.php';
require_once BADGER_PLUGIN_DIR . 'includes/class-badger-intelligence.php';
require_once BADGER_PLUGIN_DIR . 'includes/class-badger-dashboard.php';
require_once BADGER_PLUGIN_DIR . 'includes/class-badger-admin.php';

/**
 * Initialize Badger plugin.
 */
function badger_init(): void
{
    // Initialize all modules
    Badger_Rate_Limiter::get_instance();
    Badger_Detector::get_instance();
    Badger_Honeypot::get_instance();
    Badger_Blocker::get_instance();
    Badger_Robots::get_instance();
    Badger_Hardening::get_instance();
    Badger_Intelligence::get_instance();
    Badger_Admin::get_instance();
    
    // Check for database updates
    Badger_Activator::maybe_update_schema();
}
add_action('plugins_loaded', 'badger_init');

register_activation_hook(__FILE__, [Badger_Activator::class, 'activate']);
register_deactivation_hook(__FILE__, [Badger_Activator::class, 'deactivate']);
