<?php
/**
 * Manages robots.txt Disallow rules for AI crawlers.
 */

declare(strict_types=1);

if (!defined('ABSPATH')) {
    exit;
}

class Badger_Robots
{
    private static ?self $instance = null;

    public static function get_instance(): self
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function __construct()
    {
        add_filter('robots_txt', [$this, 'append_disallow_rules'], 10, 2);
    }

    /**
     * Append Disallow rules for AI crawlers to robots.txt.
     */
    public function append_disallow_rules(string $output, bool $public): string
    {
        if (!get_option('badger_robots_txt_disallow', true) || !$public) {
            return $output;
        }

        $rules = [
            'User-agent: GPTBot',
            'Disallow: /',
            '',
            'User-agent: Claude-Web',
            'Disallow: /',
            '',
            'User-agent: ClaudeBot',
            'Disallow: /',
            '',
            'User-agent: Bytespider',
            'Disallow: /',
            '',
            'User-agent: PerplexityBot',
            'Disallow: /',
            '',
            'User-agent: Google-Extended',
            'Disallow: /',
            '',
            'User-agent: CCBot',
            'Disallow: /',
        ];

        return $output . "\n# Badger AI crawler rules\n" . implode("\n", $rules);
    }
}
